/* Shell.h (public interface to ShellMain and ShellInterface)
 *
 * Global routines and variables available to
 * the sections of the compiler.  Note: do not
 * modify the variables that are marked as
 * read-only.
 */
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#ifndef _Shell_h_
#define _Shell_h_

#ifndef __EPPC__
#include <EPPC.h>
#endif

#include "ShellGlobals.h"

/* Routines: only these are available to the compiler parts */

/* Call to handle user interface updates.  Progress is a
 * percentage of work completed.  Pass a value from 1..100
 */
void	HandleEvent(void);
void	ProgressBar(short progress);

/*-----------------------------------------*/
/* The next are stored in ShellInterface.c */

/* InternalError() - display alert message, write error results
 * to results file, and call the longjmp.  This routine never
 * returns!
 */

typedef struct {
	short	id;		// less than zero, then use str below
#ifndef powerc	// align long-sized fields under 68K [Fabrizio Oddone]
	short	M68KeffPad;
#endif
	char	*msg;
} ErrMsgs[4];

void InternalError(ErrMsgs msgs, int errCode, char *file, int line);

void ShowMessage(char *msg);
void AbortMessage(char *msg, int errCode);
#endif
